#!/bin/bash

# Configuration
DOWNLOAD_LOCATION="$HOME/Downloads"
USERNAME="u" # Replace with your username
PASSWORD="p" # Replace with your password
DICODE="0000" # DI code
FORMAT="TXT" # File format (TXT, CSV)
DOWNLOAD_TYPE="full" # Download type (e.g., full, new)

# API endpoint information
BASE_URL="https://aposrd-api-gw.collegeboard.org"
AUTH_PATH="/aposrd-api-prod/webServiceAuth"
FILE_PATH="/aposrd-api-prod/fileGeneration"
RECORD_DOWNLOAD_PATH="/aposrd-api-prod/webServiceDownloaded"

# Step 1: Authenticate
echo "Step 1/4: Authenticating..."
AUTH_RESPONSE=$(curl -s -X POST "$BASE_URL$AUTH_PATH" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -H "X-CB-Catapult-Authorization-Token: CBLogin" \
  -H "X-CB-Catapult-Authentication-Token: CBLogin Web Service" \
  -d "{\"u\":\"$USERNAME\",\"p\":\"$(echo -n $PASSWORD | base64)\"}")

AUTH_TOKEN=$(echo "$AUTH_RESPONSE" | jq -r '.authToken')
AUTH_SUCCESS=$(echo "$AUTH_RESPONSE" | jq -r '.success')
AUTH_MESSAGE=$(echo "$AUTH_RESPONSE" | jq -r '.message')

if [ "$AUTH_SUCCESS" != "true" ]; then
  echo "Authentication failed: $AUTH_MESSAGE"
  exit 1
fi

echo "Authentication successful."

# Step 2: Generate File
echo "Step 2/4: Generating file..."
FILE_RESPONSE=$(curl -s -X POST "$BASE_URL$FILE_PATH" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -H "X-CB-Catapult-Authorization-Token: $AUTH_TOKEN" \
  -H "X-CB-Catapult-Authentication-Token: CBLogin Web Service" \
  -d "{\"diCode\":\"$DICODE\",\"format\":\"$FORMAT\",\"downloadType\":\"$DOWNLOAD_TYPE\"}")

FILE_URL=$(echo "$FILE_RESPONSE" | jq -r '.url')
FILE_NAME=$(echo "$FILE_RESPONSE" | jq -r '.fileName')
DOWNLOAD_ID=$(echo "$FILE_RESPONSE" | jq -r '.downloadId')
FILE_SUCCESS=$(echo "$FILE_RESPONSE" | jq -r '.success')
FILE_MESSAGE=$(echo "$FILE_RESPONSE" | jq -r '.message')

if [ "$FILE_SUCCESS" != "true" ]; then
  echo "File generation failed: $FILE_MESSAGE"
  exit 1
fi

echo "File generation successful."

# Step 3: Download File
echo "Step 3/4: Downloading file..."
curl -s -o "$DOWNLOAD_LOCATION/$FILE_NAME" "$FILE_URL" \
  -H "x-cb-catapult-authentication-token: CBLogin Web Service" \
  -H "x-cb-catapult-authorization-token: $AUTH_TOKEN"

if [ $? -ne 0 ]; then
  echo "File download failed."
  exit 1
fi

echo "File downloaded successfully to $DOWNLOAD_LOCATION/$FILE_NAME."

# Step 4: Record Successful Download
echo "Step 4/4: Recording successful download..."
RECORD_RESPONSE=$(curl -s -X POST "$BASE_URL$RECORD_DOWNLOAD_PATH" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -H "X-CB-Catapult-Authorization-Token: $AUTH_TOKEN" \
  -H "X-CB-Catapult-Authentication-Token: CBLogin Web Service" \
  -d "{\"downloadId\":\"$DOWNLOAD_ID\",\"format\":\"$FORMAT\"}")

RECORD_SUCCESS=$(echo "$RECORD_RESPONSE" | jq -r '.success')
RECORD_MESSAGE=$(echo "$RECORD_RESPONSE" | jq -r '.message')

if [ "$RECORD_SUCCESS" != "true" ]; then
  echo "Failed to record download: $RECORD_MESSAGE"
  exit 1
fi

echo "Download successfully recorded."